<?php
/**
 * Página de verificación de certificados
 * Acceso público para verificar autenticidad de certificados
 */

require_once '../config/config.php';

$numeroCertificado = $_GET['cert'] ?? '';
$hashCorto = $_GET['hash'] ?? ''; // Opcional ahora

$resultado = null;
$certificado = null;

if ($numeroCertificado) {
    $db = Database::getInstance();
    
    // Buscar certificado
    $sql = "SELECT c.*, s.nombre_completo, s.rut, s.direccion, s.fecha_solicitud,
            u.nombre_completo as generado_por_nombre
            FROM certificados c
            INNER JOIN solicitudes s ON c.solicitud_id = s.id
            LEFT JOIN usuarios u ON c.usuario_generador = u.id
            WHERE c.numero_certificado = ?";
    
    $certificado = $db->selectOne($sql, [$numeroCertificado]);
    
    if ($certificado) {
        // Si se proporcionó hash, verificarlo
        if ($hashCorto) {
            $hashReal = substr($certificado['hash_documento'], 0, 16);
            if ($hashCorto !== $hashReal) {
                $resultado = 'invalido';
            } else {
                $resultado = 'valido';
            }
        } else {
            // Sin hash proporcionado, pero certificado existe
            $resultado = 'encontrado';
        }
    } else {
        $resultado = 'no_encontrado';
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificar Certificado - Municipalidad de Loncoche</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 20px;
        }
        .verificacion-container {
            max-width: 800px;
            margin: 0 auto;
        }
        .card {
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        }
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            padding: 30px;
        }
        .resultado-valido {
            background-color: #d4edda;
            border-left: 5px solid #28a745;
            padding: 20px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .resultado-invalido {
            background-color: #f8d7da;
            border-left: 5px solid #dc3545;
            padding: 20px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .resultado-no-encontrado {
            background-color: #fff3cd;
            border-left: 5px solid #ffc107;
            padding: 20px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .info-certificado {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
        }
        .info-row {
            display: flex;
            padding: 10px 0;
            border-bottom: 1px solid #dee2e6;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .info-label {
            font-weight: 600;
            min-width: 150px;
            color: #6c757d;
        }
        .info-value {
            flex: 1;
            color: #212529;
        }
        .qr-icon {
            font-size: 80px;
            color: #667eea;
        }
    </style>
</head>
<body>
    <div class="verificacion-container">
        <div class="card">
            <div class="card-header text-center">
                <i class="fas fa-shield-alt fa-3x mb-3"></i>
                <h2 class="mb-0">Verificación de Certificado</h2>
                <p class="mb-0">Municipalidad de Loncoche</p>
            </div>
            <div class="card-body p-4">
                
                <?php if (!$numeroCertificado): ?>
                <!-- Formulario de búsqueda -->
                <div class="text-center mb-4">
                    <i class="fas fa-qrcode qr-icon"></i>
                    <h4 class="mt-3">Verificar Autenticidad del Certificado</h4>
                    <p class="text-muted">Ingrese el número de certificado para verificar su validez</p>
                </div>
                
                <form method="GET" action="">
                    <div class="mb-3">
                        <label class="form-label">Número de Certificado:</label>
                        <input type="text" name="cert" class="form-control form-control-lg" 
                               placeholder="Ej: CERT-2025-00001" required autofocus>
                        <small class="text-muted">El número de certificado aparece en el documento</small>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Código Hash (Opcional):</label>
                        <input type="text" name="hash" class="form-control" 
                               placeholder="Primeros 16 caracteres del hash">
                        <small class="text-muted">Para una verificación más completa</small>
                    </div>
                    
                    <button type="submit" class="btn btn-primary btn-lg w-100">
                        <i class="fas fa-search me-2"></i>Verificar Certificado
                    </button>
                </form>
                
                <?php elseif ($resultado === 'valido'): ?>
                <!-- Certificado válido -->
                <div class="resultado-valido">
                    <div class="text-center mb-3">
                        <i class="fas fa-check-circle fa-4x text-success"></i>
                        <h3 class="mt-3 text-success">✓ Certificado Válido y Auténtico</h3>
                        <p class="mb-0">Este certificado ha sido verificado exitosamente</p>
                    </div>
                </div>
                
                <div class="info-certificado">
                    <h5><i class="fas fa-certificate me-2"></i>Información del Certificado</h5>
                    <hr>
                    
                    <div class="info-row">
                        <span class="info-label">Número:</span>
                        <span class="info-value"><strong><?= htmlspecialchars($certificado['numero_certificado']) ?></strong></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Fecha de Emisión:</span>
                        <span class="info-value"><?= date('d/m/Y H:i', strtotime($certificado['fecha_generacion'])) ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Generado por:</span>
                        <span class="info-value"><?= htmlspecialchars($certificado['generado_por_nombre']) ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Estado:</span>
                        <span class="info-value">
                            <?php if ($certificado['firmado']): ?>
                                <span class="badge bg-success">
                                    <i class="fas fa-signature"></i> Firmado Digitalmente
                                </span>
                                <?php if ($certificado['fecha_firma']): ?>
                                <br><small class="text-muted">Firmado el <?= date('d/m/Y H:i', strtotime($certificado['fecha_firma'])) ?></small>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="badge bg-warning text-dark">Sin Firma Digital</span>
                            <?php endif; ?>
                        </span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Beneficiario:</span>
                        <span class="info-value"><?= htmlspecialchars($certificado['nombre_completo']) ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">RUT:</span>
                        <span class="info-value"><?= htmlspecialchars($certificado['rut']) ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Dirección:</span>
                        <span class="info-value"><?= htmlspecialchars($certificado['direccion']) ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Hash del Documento:</span>
                        <span class="info-value">
                            <small class="font-monospace"><?= htmlspecialchars(substr($certificado['hash_documento'], 0, 32)) ?>...</small>
                        </span>
                    </div>
                </div>
                
                <div class="alert alert-info mt-3">
                    <i class="fas fa-info-circle me-2"></i>
                    <strong>Este certificado es auténtico y ha sido emitido oficialmente por la Municipalidad de Loncoche.</strong>
                </div>
                
                <?php elseif ($resultado === 'encontrado'): ?>
                <!-- Certificado encontrado (sin hash o hash no proporcionado) -->
                <div class="resultado-valido">
                    <div class="text-center mb-3">
                        <i class="fas fa-check-circle fa-4x text-success"></i>
                        <h3 class="mt-3 text-success">✓ Certificado Válido y Auténtico</h3>
                        <p class="mb-0">Este certificado ha sido verificado exitosamente en nuestros registros</p>
                    </div>
                </div>
                
                <div class="info-certificado">
                    <h5><i class="fas fa-certificate me-2"></i>Información del Certificado</h5>
                    <hr>
                    
                    <div class="info-row">
                        <span class="info-label">Número:</span>
                        <span class="info-value"><strong><?= htmlspecialchars($certificado['numero_certificado']) ?></strong></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Beneficiario:</span>
                        <span class="info-value"><?= htmlspecialchars($certificado['nombre_completo']) ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">RUT:</span>
                        <span class="info-value"><?= htmlspecialchars($certificado['rut']) ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Dirección:</span>
                        <span class="info-value"><?= htmlspecialchars($certificado['direccion']) ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Fecha de Emisión:</span>
                        <span class="info-value"><?= date('d/m/Y H:i', strtotime($certificado['fecha_generacion'])) ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Generado por:</span>
                        <span class="info-value"><?= htmlspecialchars($certificado['generado_por_nombre']) ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Estado:</span>
                        <span class="info-value">
                            <?php if ($certificado['firmado']): ?>
                                <span class="badge bg-success">
                                    <i class="fas fa-signature"></i> Firmado Digitalmente
                                </span>
                                <?php if ($certificado['fecha_firma']): ?>
                                <br><small class="text-muted">Firmado el <?= date('d/m/Y H:i', strtotime($certificado['fecha_firma'])) ?></small>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="badge bg-warning text-dark">Sin Firma Digital</span>
                            <?php endif; ?>
                        </span>
                    </div>
                </div>
                
                <div class="alert alert-success mt-3">
                    <i class="fas fa-shield-alt me-2"></i>
                    <strong>Este certificado es auténtico y ha sido emitido oficialmente por la Municipalidad de Loncoche.</strong>
                </div>
                
                <?php elseif ($resultado === 'invalido'): ?>
                <!-- Hash no coincide -->
                <div class="resultado-invalido">
                    <div class="text-center mb-3">
                        <i class="fas fa-exclamation-triangle fa-4x text-danger"></i>
                        <h3 class="mt-3 text-danger">⚠️ Advertencia: Hash No Coincide</h3>
                        <p class="mb-0">El código hash proporcionado no coincide con nuestros registros</p>
                    </div>
                </div>
                
                <div class="alert alert-danger">
                    <h5><i class="fas fa-shield-alt me-2"></i>Posibles Razones:</h5>
                    <ul class="mb-0">
                        <li>El documento PDF ha sido modificado después de su emisión</li>
                        <li>El código hash ingresado es incorrecto</li>
                        <li>El documento puede no ser auténtico</li>
                    </ul>
                </div>
                
                <div class="alert alert-warning">
                    <i class="fas fa-phone me-2"></i>
                    <strong>Recomendación:</strong> Contacte con la Municipalidad de Loncoche para verificar la autenticidad del documento.
                </div>
                
                <?php else: ?>
                <!-- No encontrado -->
                <div class="resultado-no-encontrado">
                    <div class="text-center mb-3">
                        <i class="fas fa-times-circle fa-4x text-warning"></i>
                        <h3 class="mt-3 text-warning">Certificado No Encontrado</h3>
                        <p class="mb-0">No se encontró ningún certificado con ese número</p>
                    </div>
                </div>
                
                <div class="alert alert-warning">
                    <h5><i class="fas fa-info-circle me-2"></i>Posibles Razones:</h5>
                    <ul class="mb-0">
                        <li>El número de certificado es incorrecto</li>
                        <li>El certificado no existe en nuestro sistema</li>
                        <li>El documento puede no ser auténtico</li>
                    </ul>
                </div>
                
                <div class="alert alert-info">
                    <i class="fas fa-search me-2"></i>
                    <strong>Sugerencia:</strong> Verifique que haya ingresado correctamente el número de certificado tal como aparece en el documento.
                </div>
                <?php endif; ?>
                
                <hr class="my-4">
                
                <div class="text-center">
                    <a href="verificar.php" class="btn btn-outline-primary">
                        <i class="fas fa-redo me-2"></i>Verificar Otro Certificado
                    </a>
                    <a href="index.php" class="btn btn-outline-secondary">
                        <i class="fas fa-home me-2"></i>Ir al Inicio
                    </a>
                </div>
                
            </div>
        </div>
        
        <div class="text-center mt-4 text-white">
            <small>&copy; <?= date('Y') ?> Municipalidad de Loncoche. Todos los derechos reservados.</small>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
