<?php
require_once '../../config/config.php';

$auth = new Auth();
$auth->requireLogin();

$user = $auth->getUser();
$solicitud = new Solicitud();

// Obtener ID de solicitud
$solicitudId = isset($_GET['id']) ? intval($_GET['id']) : 0;

if (!$solicitudId) {
    header('Location: solicitudes.php');
    exit;
}

// Obtener datos de la solicitud
$datos = $solicitud->obtenerPorId($solicitudId);

if (!$datos) {
    header('Location: solicitudes.php');
    exit;
}

// Procesar acciones
$mensaje = '';
$tipoMensaje = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['accion'])) {
    switch ($_POST['accion']) {
        case 'cambiar_estado':
            if (isset($_POST['nuevo_estado'])) {
                $observaciones = $_POST['observaciones'] ?? null;
                if ($solicitud->actualizarEstado($solicitudId, $_POST['nuevo_estado'], $observaciones)) {
                    $mensaje = 'Estado actualizado exitosamente';
                    $tipoMensaje = 'success';
                    // Recargar datos
                    $datos = $solicitud->obtenerPorId($solicitudId);
                } else {
                    $mensaje = 'Error al actualizar el estado';
                    $tipoMensaje = 'danger';
                }
            }
            break;
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ver Solicitud - Panel de Administración</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="../../assets/css/admin.css" rel="stylesheet">
    <style>
        .info-card {
            background-color: #f8f9fa;
            border-left: 4px solid #0066cc;
            padding: 15px;
            margin-bottom: 15px;
            border-radius: 5px;
        }
        .info-card h6 {
            color: #0066cc;
            font-weight: 600;
            margin-bottom: 10px;
        }
        .info-row {
            display: flex;
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .info-label {
            font-weight: 600;
            min-width: 150px;
            color: #6c757d;
        }
        .info-value {
            flex: 1;
            color: #212529;
        }
        .adjunto-item {
            display: flex;
            align-items: center;
            padding: 10px;
            background-color: #fff;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            margin-bottom: 8px;
        }
        .adjunto-icon {
            font-size: 24px;
            margin-right: 15px;
            color: #0066cc;
        }
        .adjunto-info {
            flex: 1;
        }
        .certificado-card {
            border: 2px solid #28a745;
            border-radius: 8px;
            padding: 15px;
            background-color: #d4edda;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">
                        <i class="fas fa-file-alt me-2"></i>Solicitud #<?= htmlspecialchars($datos['numero_solicitud']) ?>
                    </h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <a href="solicitudes.php" class="btn btn-sm btn-outline-secondary">
                                <i class="fas fa-arrow-left me-1"></i>Volver
                            </a>
                            <button type="button" class="btn btn-sm btn-outline-primary" onclick="window.print()">
                                <i class="fas fa-print me-1"></i>Imprimir
                            </button>
                        </div>
                    </div>
                </div>

                <?php if ($mensaje): ?>
                <div class="alert alert-<?= $tipoMensaje ?> alert-dismissible fade show" role="alert">
                    <i class="fas fa-<?= $tipoMensaje === 'success' ? 'check-circle' : 'exclamation-circle' ?> me-2"></i>
                    <?= htmlspecialchars($mensaje) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php endif; ?>

                <div class="row">
                    <!-- Información del Solicitante -->
                    <div class="col-md-8">
                        <div class="card shadow mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-user me-2"></i>Datos del Solicitante</h5>
                            </div>
                            <div class="card-body">
                                <div class="info-card">
                                    <div class="info-row">
                                        <span class="info-label">Nombre Completo:</span>
                                        <span class="info-value"><strong><?= htmlspecialchars($datos['nombre_completo']) ?></strong></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">RUT:</span>
                                        <span class="info-value"><?= htmlspecialchars($datos['rut']) ?></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">Dirección:</span>
                                        <span class="info-value"><?= htmlspecialchars($datos['direccion']) ?></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">Teléfono:</span>
                                        <span class="info-value"><?= htmlspecialchars($datos['telefono']) ?></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">Email:</span>
                                        <span class="info-value"><?= htmlspecialchars($datos['email']) ?></span>
                                    </div>
                                </div>

                                <div class="info-card mt-3">
                                    <h6><i class="fas fa-info-circle me-2"></i>Información de la Solicitud</h6>
                                    <div class="info-row">
                                        <span class="info-label">Motivo:</span>
                                        <span class="info-value"><?= nl2br(htmlspecialchars($datos['motivo'])) ?></span>
                                    </div>
                                    <div class="info-row">
                                        <span class="info-label">Fecha de Solicitud:</span>
                                        <span class="info-value"><?= date('d/m/Y H:i', strtotime($datos['fecha_solicitud'])) ?></span>
                                    </div>
                                    <?php if ($datos['ip_solicitante']): ?>
                                    <div class="info-row">
                                        <span class="info-label">IP del Solicitante:</span>
                                        <span class="info-value"><?= htmlspecialchars($datos['ip_solicitante']) ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>

                                <?php if (!empty($datos['observaciones'])): ?>
                                <div class="info-card mt-3">
                                    <h6><i class="fas fa-comment me-2"></i>Observaciones</h6>
                                    <p class="mb-0"><?= nl2br(htmlspecialchars($datos['observaciones'])) ?></p>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Archivos Adjuntos -->
                        <?php if (!empty($datos['adjuntos'])): ?>
                        <div class="card shadow mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-paperclip me-2"></i>Archivos Adjuntos (<?= count($datos['adjuntos']) ?>)</h5>
                            </div>
                            <div class="card-body">
                                <?php foreach ($datos['adjuntos'] as $adjunto): ?>
                                <div class="adjunto-item">
                                    <div class="adjunto-icon">
                                        <i class="fas fa-file-<?= strpos($adjunto['tipo_mime'], 'pdf') !== false ? 'pdf' : 'image' ?>"></i>
                                    </div>
                                    <div class="adjunto-info">
                                        <strong><?= htmlspecialchars($adjunto['nombre_archivo']) ?></strong><br>
                                        <small class="text-muted">
                                            <?= number_format($adjunto['tamano_bytes'] / 1024, 2) ?> KB - 
                                            <?= date('d/m/Y H:i', strtotime($adjunto['fecha_subida'])) ?>
                                        </small>
                                    </div>
                                    <a href="<?= htmlspecialchars($adjunto['ruta_archivo']) ?>" 
                                       class="btn btn-sm btn-outline-primary" 
                                       target="_blank" 
                                       download>
                                        <i class="fas fa-download"></i> Descargar
                                    </a>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endif; ?>

                        <!-- Certificados Generados -->
                        <?php if (!empty($datos['certificados'])): ?>
                        <div class="card shadow mb-4">
                            <div class="card-header bg-success text-white">
                                <h5 class="mb-0"><i class="fas fa-certificate me-2"></i>Certificados Generados</h5>
                            </div>
                            <div class="card-body">
                                <?php foreach ($datos['certificados'] as $cert): ?>
                                <div class="certificado-card mb-3">
                                    <div class="row align-items-center">
                                        <div class="col-md-6">
                                            <h6 class="mb-2">
                                                <i class="fas fa-certificate me-2"></i>
                                                <?= htmlspecialchars($cert['numero_certificado']) ?>
                                            </h6>
                                            <p class="mb-1">
                                                <small>
                                                    <strong>Generado:</strong> <?= date('d/m/Y H:i', strtotime($cert['fecha_generacion'])) ?><br>
                                                    <strong>Por:</strong> <?= htmlspecialchars($cert['generado_por']) ?><br>
                                                    <?php if ($cert['firmado']): ?>
                                                    <strong>Firmado:</strong> <?= date('d/m/Y H:i', strtotime($cert['fecha_firma'])) ?><br>
                                                    <?php endif; ?>
                                                    <?php if ($cert['enviado_correo']): ?>
                                                    <strong>Enviado:</strong> <?= date('d/m/Y H:i', strtotime($cert['fecha_envio_correo'])) ?>
                                                    <?php endif; ?>
                                                </small>
                                            </p>
                                            <p class="mb-0">
                                                <?php if ($cert['firmado']): ?>
                                                <span class="badge bg-success"><i class="fas fa-check-circle"></i> Firmado</span>
                                                <?php else: ?>
                                                <span class="badge bg-warning"><i class="fas fa-clock"></i> Sin Firmar</span>
                                                <?php endif; ?>
                                                
                                                <?php if ($cert['enviado_correo']): ?>
                                                <span class="badge bg-primary"><i class="fas fa-paper-plane"></i> Enviado</span>
                                                <?php endif; ?>
                                            </p>
                                        </div>
                                        <div class="col-md-6 text-end">
                                            <div class="btn-group" role="group">
                                                <button type="button" class="btn btn-sm btn-success" 
                                                        onclick="descargarCertificado(<?= $cert['id'] ?>)">
                                                    <i class="fas fa-download"></i> Descargar
                                                </button>
                                                <?php if (!$cert['firmado']): ?>
                                                <button type="button" class="btn btn-sm btn-warning" 
                                                        onclick="mostrarModalFirmar(<?= $cert['id'] ?>)">
                                                    <i class="fas fa-signature"></i> Firmar
                                                </button>
                                                <?php endif; ?>
                                                <?php if (!$cert['enviado_correo']): ?>
                                                <button type="button" class="btn btn-sm btn-primary" 
                                                        onclick="enviarCertificado(<?= $cert['id'] ?>)">
                                                    <i class="fas fa-paper-plane"></i> Enviar
                                                </button>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>

                    <!-- Panel Lateral -->
                    <div class="col-md-4">
                        <!-- Estado Actual -->
                        <div class="card shadow mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Estado</h5>
                            </div>
                            <div class="card-body text-center">
                                <h3 class="mb-3">
                                    <?php
                                    $estados = [
                                        'pendiente' => '<span class="badge bg-warning text-dark p-3"><i class="fas fa-clock me-2"></i>Pendiente</span>',
                                        'en_proceso' => '<span class="badge bg-info p-3"><i class="fas fa-spinner me-2"></i>En Proceso</span>',
                                        'aprobada' => '<span class="badge bg-success p-3"><i class="fas fa-check-circle me-2"></i>Aprobada</span>',
                                        'rechazada' => '<span class="badge bg-danger p-3"><i class="fas fa-times-circle me-2"></i>Rechazada</span>',
                                        'enviada' => '<span class="badge bg-primary p-3"><i class="fas fa-paper-plane me-2"></i>Enviada</span>'
                                    ];
                                    echo $estados[$datos['estado']] ?? '<span class="badge bg-secondary p-3">Desconocido</span>';
                                    ?>
                                </h3>
                                
                                <form method="POST" class="mt-3">
                                    <input type="hidden" name="accion" value="cambiar_estado">
                                    <div class="mb-3">
                                        <label class="form-label">Cambiar Estado:</label>
                                        <select name="nuevo_estado" class="form-select" required>
                                            <option value="">Seleccione...</option>
                                            <option value="pendiente" <?= $datos['estado'] === 'pendiente' ? 'selected' : '' ?>>Pendiente</option>
                                            <option value="en_proceso" <?= $datos['estado'] === 'en_proceso' ? 'selected' : '' ?>>En Proceso</option>
                                            <option value="aprobada" <?= $datos['estado'] === 'aprobada' ? 'selected' : '' ?>>Aprobada</option>
                                            <option value="rechazada" <?= $datos['estado'] === 'rechazada' ? 'selected' : '' ?>>Rechazada</option>
                                            <option value="enviada" <?= $datos['estado'] === 'enviada' ? 'selected' : '' ?>>Enviada</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Observaciones:</label>
                                        <textarea name="observaciones" class="form-control" rows="3" 
                                                  placeholder="Opcional..."><?= htmlspecialchars($datos['observaciones'] ?? '') ?></textarea>
                                    </div>
                                    <button type="submit" class="btn btn-primary w-100">
                                        <i class="fas fa-save me-2"></i>Actualizar Estado
                                    </button>
                                </form>
                            </div>
                        </div>

                        <!-- Acciones Rápidas -->
                        <div class="card shadow mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-bolt me-2"></i>Acciones</h5>
                            </div>
                            <div class="card-body">
                                <?php if (empty($datos['certificados'])): ?>
                                <button type="button" class="btn btn-success w-100 mb-2" 
                                        onclick="generarCertificado(<?= $solicitudId ?>)">
                                    <i class="fas fa-file-pdf me-2"></i>Generar Certificado
                                </button>
                                <?php endif; ?>
                                
                                <button type="button" class="btn btn-info w-100 mb-2" 
                                        onclick="copiarAlPortapapeles('<?= htmlspecialchars($datos['numero_solicitud']) ?>')">
                                    <i class="fas fa-copy me-2"></i>Copiar N° Solicitud
                                </button>
                                
                                <a href="mailto:<?= htmlspecialchars($datos['email']) ?>" 
                                   class="btn btn-outline-primary w-100 mb-2">
                                    <i class="fas fa-envelope me-2"></i>Enviar Email
                                </a>
                            </div>
                        </div>

                        <!-- Información del Procesamiento -->
                        <?php if ($datos['fecha_procesada']): ?>
                        <div class="card shadow mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fas fa-history me-2"></i>Procesamiento</h5>
                            </div>
                            <div class="card-body">
                                <p class="mb-2">
                                    <strong>Procesado por:</strong><br>
                                    <?= htmlspecialchars($datos['procesado_por'] ?? 'N/A') ?>
                                </p>
                                <p class="mb-0">
                                    <strong>Fecha:</strong><br>
                                    <?= date('d/m/Y H:i', strtotime($datos['fecha_procesada'])) ?>
                                </p>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <!-- Modal para Firmar Certificado -->
    <div class="modal fade" id="modalFirmar" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-warning">
                    <h5 class="modal-title"><i class="fas fa-signature me-2"></i>Firmar Certificado</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form id="formFirmar" enctype="multipart/form-data">
                    <div class="modal-body">
                        <input type="hidden" id="certificadoIdFirmar" name="certificado_id">
                        
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            <small>Suba su certificado digital (.pfx o .p12) y proporcione la contraseña.</small>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Certificado Digital (.pfx, .p12):</label>
                            <input type="file" class="form-control" name="certificado_pfx" 
                                   accept=".pfx,.p12" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Contraseña del Certificado:</label>
                            <input type="password" class="form-control" name="password_pfx" 
                                   placeholder="Ingrese la contraseña" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-warning">
                            <i class="fas fa-signature me-2"></i>Firmar Certificado
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="../../assets/js/admin.js"></script>
    <script>
        function mostrarModalFirmar(certificadoId) {
            $('#certificadoIdFirmar').val(certificadoId);
            $('#modalFirmar').modal('show');
        }

        $('#formFirmar').on('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            showLoading('Firmando certificado...');
            
            $.ajax({
                url: '../api/certificados.php?action=firmar',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    hideLoading();
                    if (response.success) {
                        showToast('success', 'Certificado firmado exitosamente');
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        showToast('error', response.message);
                    }
                },
                error: function(xhr) {
                    hideLoading();
                    showToast('error', 'Error al firmar el certificado');
                }
            });
        });
    </script>
</body>
</html>
