# 📋 Guía: Generar y Firmar Certificados Automáticamente

## ✨ NUEVA FUNCIONALIDAD

Ahora puedes **generar y firmar el certificado en un solo paso** con la firma visible en la parte inferior izquierda del documento.

---

## 🎯 CARACTERÍSTICAS

### ✅ Lo Nuevo:

1. **Modal mejorado** al generar certificado
2. **Opción de firma automática** con checkbox
3. **Firma visible** en esquina inferior izquierda
4. **Todo en un solo paso** - no necesitas firmar después
5. **Validación de contraseña** durante la generación

### 🎨 Firma Visual:

La firma aparece en un cuadro azul en la esquina inferior izquierda:

```
┌─────────────────────────────────┐
│  🔒 FIRMA DIGITAL               │
├─────────────────────────────────┤
│  Firmado por:   Juan Pérez      │
│  Email:         jperez@correo.cl│
│  Fecha:         27/12/2025 10:30│
│  Válido hasta:  27/12/2026      │
│                                  │
│  ✓ Firmado digitalmente         │
└─────────────────────────────────┘
```

---

## 📖 CÓMO USAR

### Opción 1: Generar SIN Firma

1. Click en **"Generar Certificado"**
2. Se abre modal
3. Dejar checkbox **desactivado**
4. Click **"Generar Certificado"**
5. ✅ PDF generado sin firma

### Opción 2: Generar CON Firma (Automático)

1. Click en **"Generar Certificado"**
2. Se abre modal
3. ✅ **Activar** checkbox "Generar y firmar automáticamente"
4. Se despliegan campos de firma:
   - **Certificado Digital**: Seleccionar archivo .pfx o .p12
   - **Contraseña**: Escribir contraseña del certificado
5. Click **"Generar y Firmar Certificado"**
6. ⏳ Sistema procesa (10-15 segundos)
7. ✅ PDF generado Y firmado

---

## 🎬 FLUJO COMPLETO

```
Usuario hace click "Generar Certificado"
    ↓
Se abre modal con opciones
    ↓
Usuario decide:
    ├─ Sin firma → Generar normal
    │       ↓
    │   PDF sin firma (1-2 seg)
    │
    └─ Con firma → Activa checkbox
            ↓
        Campos de firma aparecen
            ↓
        Usuario carga .pfx y escribe contraseña
            ↓
        Click "Generar y Firmar"
            ↓
        Sistema valida contraseña
            ├─ ❌ Incorrecta → Error
            └─ ✅ Correcta → Continúa
                    ↓
                Genera PDF con contenido
                    ↓
                Agrega firma en esquina inferior izquierda
                    ↓
                Guarda PDF firmado
                    ↓
                Actualiza BD (firmado = 1)
                    ↓
                ✅ Listo - certificado generado y firmado
```

---

## 🖼️ ASPECTO DEL MODAL

```
╔══════════════════════════════════════════════╗
║  Generar Certificado                     × ║
╠══════════════════════════════════════════════╣
║                                              ║
║  ℹ️ ¿Desea firmar el certificado            ║
║     automáticamente?                         ║
║                                              ║
║  Si desea generar y firmar en un solo       ║
║  paso, active la opción y cargue su         ║
║  certificado digital.                        ║
║                                              ║
║  ☐ Generar y firmar automáticamente         ║
║                                              ║
║  [Si se activa, aparece:]                   ║
║                                              ║
║  ─────────────────────────────────────────  ║
║  Datos de Firma Digital                     ║
║                                              ║
║  Certificado Digital (.pfx, .p12):          ║
║  [Elegir archivo...]                        ║
║                                              ║
║  Contraseña del Certificado:                ║
║  [••••••••••] 👁️                            ║
║                                              ║
║  ⚠️ Importante: La firma se agregará en     ║
║     la esquina inferior izquierda.          ║
║                                              ║
║          [Cancelar] [Generar Certificado]   ║
╚══════════════════════════════════════════════╝
```

---

## 🔧 VENTAJAS DEL SISTEMA

### vs Método Anterior (2 pasos):

**Antes:**
1. Generar certificado → Esperar
2. Firmar certificado → Cargar .pfx → Esperar
3. Total: ~30 segundos, 2 interacciones

**Ahora:**
1. Generar con firma → Cargar .pfx → Esperar
2. Total: ~15 segundos, 1 interacción

### Beneficios:

✅ **Más rápido** - todo en un paso  
✅ **Menos clics** - una sola acción  
✅ **Más conveniente** - modal único  
✅ **Firma visible** - esquina inferior izquierda  
✅ **Validación inmediata** - error si contraseña incorrecta  

---

## 📍 UBICACIÓN DE LA FIRMA

La firma se ubica en:
- **Posición**: Esquina inferior izquierda
- **Desde el margen izquierdo**: 20mm
- **Desde el fondo**: 60mm
- **Tamaño**: 80mm ancho × 50mm alto
- **Color borde**: Azul (#0066cc)
- **Fondo**: Azul claro (#f0f8ff)

### Elementos de la Firma:

1. **Header** - Fondo azul con "🔒 FIRMA DIGITAL"
2. **Firmado por** - Nombre del certificado
3. **Email** - Email del firmante
4. **Fecha** - Fecha y hora exacta de firma
5. **Válido hasta** - Fecha de expiración del certificado
6. **Verificación** - "✓ Firmado digitalmente" en verde

---

## 🔍 VALIDACIONES

### Durante la Generación con Firma:

1. ✅ Archivo .pfx existe
2. ✅ Extensión es .pfx o .p12
3. ✅ Contraseña es correcta
4. ✅ Certificado no ha expirado
5. ✅ Certificado contiene clave privada
6. ✅ Se puede generar el PDF

### Mensajes de Error:

- **"Contraseña incorrecta"** → Revisar contraseña del .pfx
- **"Certificado ha expirado"** → Obtener certificado nuevo
- **"Certificado inválido"** → Verificar archivo .pfx
- **"No se pudo generar PDF"** → Revisar permisos

---

## 💡 CONSEJOS DE USO

### Para Funcionarios:

1. **Tener certificado digital listo** antes de generar
2. **Recordar contraseña** del certificado
3. **Verificar validez** del certificado antes de usar
4. **Descargar PDF generado** para verificar firma

### Para Administradores del Sistema:

1. **Instalar dependencias**: `composer require setasign/fpdi tecnickcom/tcpdf`
2. **Verificar permisos**: uploads/, certificates/
3. **Revisar logs**: si hay errores de generación
4. **Backup**: de certificados digitales

---

## 🎓 CASOS DE USO

### Caso 1: Funcionario con Certificado

```
Juan es funcionario municipal y tiene certificado E-Certchile

1. Recibe solicitud de certificado
2. Revisa datos en el sistema
3. Click "Generar Certificado"
4. Activa "Generar y firmar automáticamente"
5. Carga su archivo .pfx
6. Escribe su contraseña
7. Click "Generar y Firmar Certificado"
8. ✅ En 15 segundos tiene certificado firmado
9. Click "Enviar" para enviar por email
```

### Caso 2: Funcionario sin Certificado

```
María no tiene certificado digital

1. Recibe solicitud
2. Click "Generar Certificado"
3. NO activa checkbox de firma
4. Click "Generar Certificado"
5. ✅ PDF generado sin firma
6. Imprime y firma manualmente
7. Escanea y envía
```

---

## 🔐 SEGURIDAD

### Datos del Certificado:

- ✅ **Archivo temporal** - se borra después de usar
- ✅ **Contraseña en memoria** - nunca se guarda
- ✅ **Validación OpenSSL** - estándar PHP
- ✅ **No se almacena** - certificado no queda en servidor

### Registro de Auditoría:

Cada generación con firma registra:
- Quién generó (usuario)
- Quién firmó (del certificado)
- Cuándo (fecha/hora)
- Qué (número de certificado)
- Hash del documento

---

## 📊 COMPARACIÓN

| Característica | Método Anterior | Método Nuevo |
|----------------|-----------------|--------------|
| Pasos necesarios | 2 | 1 |
| Tiempo total | ~30 seg | ~15 seg |
| Modales abiertos | 2 | 1 |
| Carga de archivos | 1 (después) | 1 (durante) |
| Firma visible | Sí | Sí (mejor ubicada) |
| Ubicación firma | Final del doc | Inferior izquierda |
| Tamaño firma | Variable | Fijo (80×50mm) |
| Color firma | Azul | Azul con fondo |
| Validación | Después | Durante |

---

## ✅ RESULTADO FINAL

Después de generar con firma automática:

1. **PDF creado** en uploads/certificados/
2. **Firma visible** en esquina inferior izquierda
3. **BD actualizada** con firmado=1
4. **Log registrado** con detalles
5. **Listo para descargar/enviar**

---

## 🚀 PRÓXIMOS PASOS

Después de generar:

- **Descargar** - Ver y verificar PDF
- **Enviar** - Email al solicitante
- **Imprimir** - Si necesita copia física

---

**Versión:** 1.0.5 (Auto-Sign Feature)  
**Fecha:** 27 de Diciembre, 2025  
**Estado:** ✅ Funcionando
